#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <climits>
using namespace std;

struct vektor {
	int x, y, index;
	float ugao;
};

float ugao(int x, int y) {
	float temp=atan2(y, x) * 180 / M_PI;
	if (temp<0) temp+=360;
	return temp;
}

bool sortiranje(vektor a, vektor b) {
	return a.ugao<b.ugao;
}

int main() {
	int n, r=0, max=-INT_MAX, max_x=0, max_y=0, best_l, best_r;
	scanf("%d", &n);
	std::vector<vektor> arr;

	for (int i=0; i<n; i++) {
		int x, y;
		scanf("%d %d", &x, &y);
		arr.push_back({x,y,i,ugao(x, y)});
	}

	std::sort(arr.begin(), arr.end(), sortiranje);

	for (int i=0; i<n; i++) arr.push_back({arr[i].x,arr[i].y,arr[i].index,arr[i].ugao+360});

	for (int l=0; l<n; l++) {
		while (arr[r].ugao-arr[l].ugao<180) {
		    r++;
		    max_x+=arr[r].x;
		    max_y+=arr[r].y;
		}
		if (std::sqrt(max_x*max_x+max_y*max_y)>max) {
		    max=std::sqrt(max_x*max_x+max_y*max_y);
		    best_l=l;
		    best_r=r;
		}
	}
	
	printf("%d\n", best_r-best_l);
	for (int i=best_l; i<best_r; i++) printf("%d ", arr[i].index+1);
	return 0;
}